import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a new figure
fig, ax = plt.subplots(figsize=(10, 8))

# Define colors
ingredient1_color = 'red'
ingredient2_color = 'blue'
clean_empty_color = 'lightgray'
hand_color = 'white'

# Add dispensers
ax.add_patch(patches.Rectangle((1, 8), 1, 0.5, edgecolor='black', facecolor=ingredient1_color))
ax.text(1.5, 8.25, 'dispenser_1\ningredient1', va='center', ha='center', fontsize=8, color='white')

ax.add_patch(patches.Rectangle((5, 8), 1, 0.5, edgecolor='black', facecolor=ingredient2_color))
ax.text(5.5, 8.25, 'dispenser_2\ningredient2', va='center', ha='center', fontsize=8, color='white')

# Add shots
ax.add_patch(patches.Rectangle((1, 5), 1, 0.5, edgecolor='black', facecolor=clean_empty_color))
ax.text(1.5, 5.25, 'shot_1\nclean, empty', va='center', ha='center', fontsize=8, color='black')

ax.add_patch(patches.Rectangle((3, 5), 1, 0.5, edgecolor='black', facecolor=clean_empty_color))
ax.text(3.5, 5.25, 'shot_2\nclean, empty', va='center', ha='center', fontsize=8, color='black')

ax.add_patch(patches.Rectangle((5, 5), 1, 0.5, edgecolor='black', facecolor=clean_empty_color))
ax.text(5.5, 5.25, 'shot_3\nclean, empty', va='center', ha='center', fontsize=8, color='black')

# Add shaker
ax.add_patch(patches.Circle((3.5, 3), 0.5, edgecolor='black', facecolor=clean_empty_color))
ax.text(3.5, 3, 'shaker_1\nclean, empty\nlevel l0', va='center', ha='center', fontsize=8, color='black')

# Add hands
ax.add_patch(patches.Rectangle((0.5, 1), 1, 0.5, edgecolor='black', facecolor=hand_color))
ax.text(1, 1.25, 'left_hand\nempty', va='center', ha='center', fontsize=8, color='black')

ax.add_patch(patches.Rectangle((5.5, 1), 1, 0.5, edgecolor='black', facecolor=hand_color))
ax.text(6, 1.25, 'right_hand\nempty', va='center', ha='center', fontsize=8, color='black')

# Add legend
legend_elements = [
    patches.Patch(facecolor=ingredient1_color, edgecolor='black', label='ingredient1'),
    patches.Patch(facecolor=ingredient2_color, edgecolor='black', label='ingredient2'),
    patches.Patch(facecolor=clean_empty_color, edgecolor='black', label='clean & empty')
]
ax.legend(handles=legend_elements, loc='upper left', bbox_to_anchor=(1, 1))

# Set limits and hide axes
ax.set_xlim(0, 8)
ax.set_ylim(0, 9)
ax.axis('off')

# Save the figure
plt.savefig('barman/one_shot/ini_diagram_code/attempts/attempt_32.png', bbox_inches='tight')
plt.close()